# みりん鉄千パック 使用ガイド

**バージョン**: 4.1.2
**対応**: Minecraft Bedrock Edition 1.21.110以降
**制作**: みりん (@Onimirin)

---

## 目次

1. [鉄千とは?](#鉄千とは)
2. [パックの導入方法](#パックの導入方法)
3. [ゲームの始め方（初心者向け）](#ゲームの始め方初心者向け)
4. [ゲームの始め方（上級者向け）](#ゲームの始め方上級者向け)
5. [ゲームの流れ](#ゲームの流れ)
6. [チームモード](#チームモード)
7. [ルール設定の詳細](#ルール設定の詳細)
8. [ランキングと結果](#ランキングと結果)
9. [便利な機能](#便利な機能)
10. [よくある質問 (FAQ)](#よくある質問-faq)

---

## 鉄千とは?

「鉄千（てっせん）」は、**素材を集める速さを競うミニゲーム**です。

プレイヤーはそれぞれの拠点にあるチェストに素材を集め、一番早く目標数に到達した人が勝ちです。

**基本ルール**:
- デフォルトでは **鉄インゴットを1000個** 集めます
- 素材や目標数は設定で自由に変更できます
- 最大20人（20拠点）まで対応
- 個人戦とチーム戦の両方に対応

**対応素材**:

| 素材 | アイテム名 |
|------|-----------|
| 鉄 | 鉄インゴット |
| 金 | 金インゴット |
| 銅 | 銅インゴット |
| ダイヤモンド | ダイヤモンド |
| クォーツ | ネザークォーツ |

---

## パックの導入方法

### 必要なパック

このパックは**ビヘイビアパック（BP）**と**リソースパック（RP）**の2つで構成されています。両方をワールドに適用してください。

### 導入手順

1. BP・RPのフォルダをMinecraftのアドオンフォルダに配置します
2. Minecraftを起動し、対象のワールドの設定を開きます
3. 「アドオン」→「ビヘイビアパック」から「みりん鉄千BP」を有効化します
4. 同様に「リソースパック」から対応RPを有効化します
5. **実験的機能は不要**です。そのまま使えます

### 初回起動時の確認

ワールドに入ると、チャットに初期化メッセージが表示されます。エラーが出ていなければ正常に動作しています。

---

## ゲームの始め方（初心者向け）

初めてこのパックを使う方は、こちらの手順がおすすめです。

### ステップ1: メニューを開く

以下のどちらかの方法でメニューを開きます。

- **方法A**: インベントリにある「会場設置アイテム」を手に持って右クリック（使用ボタン）
- **方法B**: チャットで `/tetusen:menu` と入力

### ステップ2: 初心者モードを選ぶ

メニューが表示されたら **「初めてプレイする」** を選びます。

### ステップ3: 会場を設置する

**「会場を設置する」** を選びます。

- **1～10人の場合**: 「少人数（1～10人）」を選びます → 拠点が10個作られます
- **11～20人の場合**: 先に少人数を設置してから、「大人数（11～20人）」で拠点を追加します

> **注意**: 会場設置は拠点のストラクチャー（建物）を読み込む処理です。既に拠点がある場合はリセットされます。

### ステップ4: 設定を確認する（任意）

必要に応じて **「簡単な設定を変更する」** から以下を変更できます。

- **目標素材**: 鉄インゴット、金インゴットなど
- **目標数量**: 集める個数（デフォルト: 1000）
- **難易度**: ピースフル / イージー / ノーマル / ハード

### ステップ5: ゲームを開始する

**「ゲームをスタート!」** を選ぶと、現在のルールの確認画面が表示されます。内容を確認して **「ゲームを開始!」** を押すとカウントダウンが始まります。

**カウントダウン**:
- 3... 2... 1... **ゲームスタート!**
- カウントダウン中に画面にタイトルが表示され、効果音が鳴ります

---

## ゲームの始め方（上級者向け）

全ての設定にアクセスしたい場合は、メニューから **「全機能にアクセスする」** を選びます。

### 上級者モードで出来ること

| メニュー項目 | 説明 |
|-------------|------|
| ゲームを開始する | ルール確認後にゲーム開始 |
| ルール設定 | 11項目の詳細設定（後述） |
| 会場を作成 | 拠点の設置（1～10 / 11～20） |
| チーム管理 | チームの作成/編集/削除（チームモード時） |
| ランキングを表示 | ランキング画面 |
| その他 | 音楽再生、表示更新、拠点リセットなど |

---

## ゲームの流れ

### 1. 拠点の登録

ゲーム開始後、各プレイヤーは自分が使う拠点の**看板をタッチ**します。

- 看板をタッチすると、その拠点が自分に割り当てられます
- 看板に自分の名前が表示されます
- 効果音（レベルアップ音）が鳴って割り当て完了です

> **注意**: 他の人が既に登録した拠点はタッチしても登録できません。空いている拠点を選んでください。

### 2. 素材を集める

通常のサバイバルプレイで素材を集めます。

- 鉄の場合: 鉄鉱石を掘る → かまどで焼く → 鉄インゴットを入手
- 集めた素材は**自分の拠点のチェスト**に入れてください
- チェストに入った素材だけがカウントされます

### 3. 進捗の確認

画面下部の**アクションバー**にリアルタイムで表示されます。

```
現在の鉄の数: 523個   経過時間: 0h32m15s
```

自動削除が発生している場合は内訳も表示されます。

```
鉄の数: 1523個 (チェスト: 523個, 自動削除: 1000個)   経過時間: 1h05m30s
```

### 4. チェストが満杯になったら

チェストの中身が**90%以上**になると、目標素材が自動的に回収されます。

- 回収された分はカウントに**加算**されるので、数が減ることはありません
- 「チェストがいっぱいになったため、鉄XX個を自動的に消去しました」とメッセージが出ます
- **この機能は常にON**です。設定で変更はできません

> **ポイント**: チェストが詰まる心配がないので、ひたすら素材を入れ続けてOKです!

### 5. 半数達成

目標の半分（例: 1000個中500個）に到達すると、全体にメッセージが流れます。

### 6. 目標達成（クリア）!

目標数に到達すると...

- 画面に大きく **「鉄千完了」** と表示されます
- 全プレイヤーにクリアメッセージが流れます
- 達成時間が記録されます
- クリア後もゲームは続行します（他のプレイヤーがまだプレイ中の場合）

### 7. ゲーム終了

全員がクリアした、または管理者がゲームを終了すると、ランキングが確認できるようになります。

**強制終了の方法**:
メニューから **「ゲームを終了する」** → 確認画面で **「終了する」** を選択

---

## チームモード

チームモードでは、複数のプレイヤーが1つのチームとして協力して素材を集めます。

### チームモードの有効化

上級者モードの **「ルール設定」** → **「チームモード」** をONにします。

### チームの作成

1. メニューから **「チーム管理」** → **「チームを作成」** を選びます
2. チームに入れるメンバーにチェックを入れます
3. チーム名を入力します（空欄の場合は自動生成されます）
4. 「作成」を押すとチームが完成します

### チームモードの仕組み

- チームメンバーは**1つの拠点を共有**します
- 全員が同じチェストに素材を入れ、合計がカウントされます
- 看板には「ここは [チーム名] チームの拠点です」と表示されます
- チームの誰かが看板をタッチすると、チーム全体に拠点が割り当てられます

### 拠点の引き継ぎ

チーム作成時に、メンバーの誰かが既に個人拠点を持っていた場合、その拠点をチームの拠点として引き継ぐかどうかを選べます。引き継ぐと、既に集めた素材もそのまま引き継がれます。

### チームの編集

作成後も以下の変更が可能です:

- チーム名の変更
- メンバーの追加
- メンバーの削除（0人になったチームは自動削除）

### チームランキング

チームモードではチーム単位のランキングが表示されます。各チームの達成時間・メンバー構成が確認できます。

---

## ルール設定の詳細

上級者モードの **「ルール設定」** で変更できる全11項目です。

| 設定項目 | 初期値 | 選択肢 | 説明 |
|----------|--------|--------|------|
| **難易度** | ハード | ピースフル / イージー / ノーマル / ハード | ワールドの難易度です。ピースフルだと敵MOBが出ません |
| **経過時間** | ON | ON / OFF | ONにするとアクションバーとランキングに経過時間が表示されます |
| **半数納品の通知** | 最初の達成者のみ | 最初の達成者のみ / 全ての達成者 | 目標の半数に到達した時の通知方法です |
| **鉱脈探知** | ON | ON / OFF | ONにすると、鉄の原石ブロックの上にいるプレイヤーを全体に通知します |
| **開始時全員サバイバル** | ON | ON / OFF | ONにすると、ゲーム開始時に全員がサバイバルモードになります |
| **常時暗視** | OFF | ON / OFF | ONにすると、全プレイヤーに暗視エフェクトが付きます。洞窟探索が楽になります |
| **3分ごとのアイテム消去** | OFF | ON / OFF | ONにすると、3分ごとにワールド上のドロップアイテムを自動削除します。10秒前に警告が出ます |
| **拠点座標の表示** | ON | ON / OFF | ONにすると、ゲーム開始時にサイドバーに自分の拠点座標が表示されます |
| **目標素材** | 鉄インゴット | 鉄 / 金 / 銅 / ダイヤ / クォーツ | 集める素材の種類を変更します |
| **目標数量** | 1000 | 1～100,000 | 集める個数を変更します |
| **チームモード** | OFF | ON / OFF | チーム戦の有効/無効を切り替えます |

> **ヒント**: 設定を変更すると、全プレイヤーのチャットに変更内容が表示されます。

---

## ランキングと結果

ゲーム終了後（または強制終了後）に、メニューからランキングを確認できます。

### ランキングの種類

#### 1. 鉄千ランキング（メインランキング）

達成時間が早い順に表示されます。未完了の場合は `--h--m--s` と表示されます。

#### 2. 掘った鉄鉱石ランキング

鉄鉱石（通常+深層）の合計採掘数が多い順に表示されます。個人の貢献度が分かるランキングです。

> **チームモードでのポイント**: チーム戦では拠点のチェスト素材数はチーム全員で同じになりますが、「掘った鉄鉱石」は個人ごとにカウントされるため、誰がどれだけ貢献したかが分かります。

#### 3. ランダムランキング（3つ）

ゲーム開始時に、以下の7種類からランダムで3つが選ばれます。

| ランキング名 | 内容 | 順位の基準 |
|-------------|------|-----------|
| ダイヤ採掘数 | ダイヤモンド鉱石の採掘数 | 多い方が上位 |
| 死亡回数 | ゲーム中の死亡回数 | 少ない方が上位 |
| 水中時間 | 水中にいた合計時間 | 短い方が上位 |
| 敵討伐数 | 倒した敵MOBの数 | 多い方が上位 |
| ラピスラズリ採掘数 | ラピスラズリ鉱石の採掘数 | 多い方が上位 |
| 石炭採掘数 | 石炭鉱石の採掘数 | 多い方が上位 |
| 最初に鉄を掘った時間 | 最初に鉄鉱石を掘った経過時間 | 早い方が上位 |

### 個人結果

自分だけの詳細な統計を確認できます。

- 完了時間（または「未完了」）
- 順位 / 完了人数
- 掘った鉄鉱石数
- ダイヤモンド採掘数
- 死亡回数
- 水中時間
- 倒したモブ数
- ラピスラズリ採掘数
- 石炭採掘数
- 最初に鉄を掘った時間とその順位

---

## 便利な機能

### ゲーム状況の確認

ゲーム中にメニューを開いて **「ゲーム状況を確認」** を選ぶと、全プレイヤー（またはチーム）の現在の進捗が一覧で確認できます。

### 音楽再生

メニュー → **「その他」** → **「明るいホタルノヒカリ」** で、BGMを流すことができます。自分だけ、または全員に再生可能です。

### 表示の更新

データの表示がおかしい場合は、メニュー → **「その他」** → **「表示を更新」** でキャッシュをクリアできます。

### チーム看板の更新

チームモードで看板の表示がずれた場合、メニュー → **「その他」** → **「チーム看板を更新」** で全拠点の看板テキストを一括更新できます。

### デバッグ情報の表示

会場設置アイテムを**スニーク（しゃがみ）しながら使用**すると、拠点の詳細な技術情報が表示されます。トラブルシューティング時に便利です。

### 途中参加

ゲーム開始後にワールドに入ったプレイヤーも、看板をタッチすれば途中参加できます。スコアボードは自動でリセットされます。

---

## よくある質問 (FAQ)

### Q: チェストが満杯になったらどうなりますか?

**A**: チェスト内の目標素材が自動的に回収されます。回収された分もカウントに加算されるので、素材数が減ることはありません。安心してどんどん素材を入れてください。

### Q: 目標素材以外のアイテムをチェストに入れてもいいですか?

**A**: 入れても問題ありません。カウントされるのは目標素材だけです。ただし、チェストの空きが減るため、こまめに整理すると効率的です。

### Q: 拠点の看板を壊してしまいました

**A**: 看板は自動的に復元されます。看板を攻撃したり壊そうとすると、ストラクチャーが再読み込みされて元に戻ります。

### Q: ゲーム中に設定を変更できますか?

**A**: ゲーム開始前にのみ設定変更が可能です。ゲーム中は変更できません。

### Q: 途中でワールドを出ても大丈夫ですか?

**A**: はい。ゲームの進捗データはワールドに保存されています。再度ワールドに入ればそのまま続けられます。

### Q: チームモードで個人の貢献度は分かりますか?

**A**: はい。「掘った鉄鉱石ランキング」は個人ごとにカウントされるため、チーム内で誰がどれだけ貢献したかが分かります。

### Q: 目標数は最大いくつまで設定できますか?

**A**: 最大100,000個まで設定できます。

### Q: 何人まで同時にプレイできますか?

**A**: 最大20人（20拠点）まで対応しています。10人以下の場合は「少人数」、11～20人の場合は「大人数」で会場を設置してください。

### Q: 3分ごとのアイテム消去とチェストの自動削除は別の機能ですか?

**A**: はい、別の機能です。

| 機能 | 対象 | 設定 |
|------|------|------|
| **チェスト自動削除** | 拠点チェスト内の目標素材 | 常にON（変更不可） |
| **3分ごとのアイテム消去** | ワールド上のドロップアイテム全て | ON/OFF切り替え可能 |

### Q: 鉱脈探知って何ですか?

**A**: 鉄の原石ブロック（鉄鉱脈）の上にいるプレイヤーを検知して、全体にメッセージで通知する機能です。設定でON/OFFを切り替えられます。

### Q: メニューを開くコマンドは?

**A**: チャットで `/tetusen:menu` と入力するか、会場設置アイテムを使用してください。

---

## 設定早見表

| やりたいこと | 設定場所 |
|-------------|---------|
| 素材を鉄以外に変えたい | ルール設定 → 目標素材 |
| 目標数を変えたい | ルール設定 → 目標数量 |
| チーム戦にしたい | ルール設定 → チームモード → ON |
| 洞窟を明るくしたい | ルール設定 → 常時暗視 → ON |
| ドロップアイテムを自動で消したい | ルール設定 → 3分ごとのアイテム消去 → ON |
| 拠点座標を隠したい | ルール設定 → 拠点座標の表示 → OFF |
| 時間を非表示にしたい | ルール設定 → 経過時間 → OFF |
| 敵MOBを出したくない | ルール設定 → 難易度 → ピースフル |

---

## クレジット

制作: みりん (https://x.com/Onimirin)
バージョン: 4.1.0
